/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.client;

import com.filenet.api.collection.GroupSet;
import com.filenet.api.collection.RealmSet;
import com.filenet.api.collection.UserSet;
import com.filenet.api.constants.FilteredPropertyType;
import com.filenet.api.constants.PrincipalSearchAttribute;
import com.filenet.api.constants.PrincipalSearchSortType;
import com.filenet.api.constants.PrincipalSearchType;
import com.filenet.api.core.Connection;
import com.filenet.api.core.EntireNetwork;
import com.filenet.api.core.Factory;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.security.Group;
import com.filenet.api.security.Realm;
import com.filenet.api.security.User;
import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.VWSecurityQueryResults;
import java.security.PrivilegedExceptionAction;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Vector;

public class ORBFetchUserList
implements PrivilegedExceptionAction {
    private static final String m_className = "ORBFetchUserList";
    protected static final Logger logger = Logger.getLogger("filenet.pe.peorb.client");
    private static final long serialVersionUID = 464L;
    protected static final long INTERNAL_NUM = 234L;
    private static PropertyFilter pf = null;
    private String m_cempURI = null;
    private int m_maxNumToReturn = 0;
    private int m_queryType = 0;
    private String m_startRecord = null;
    private String m_searchPattern = null;
    private String m_domain = null;
    private int m_searchType = 0;
    private int m_sortType = 0;
    private long m_argFlag = 0L;
    private boolean firstTime = true;
    private Connection myConnection = null;
    private EntireNetwork entireNetwork = null;
    private RealmSet allRealms = null;
    private boolean theQueryIsOver = false;
    private Iterator realmIter = null;
    private Realm currentRealm = null;
    private UserSet theUsers = null;
    private GroupSet theGroups = null;
    private Iterator userIter = null;
    private Iterator groupIter = null;
    private boolean doneWithThisRealmsUsers = false;
    private boolean doneWithThisRealmsGroups = false;
    private int numberFetchedThisTime = 0;
    private Calendar lastTouched = null;

    public static String _get_FILE_DATE() {
        return "$Date:   29 Jun 2007 01:45:34  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.19  $";
    }

    protected ORBFetchUserList(String paramCEMPURL, int paramMaxNumToReturn, int paramQueryType, String paramStartRecord, String paramSearchPattern, String paramDomain, int paramSearchType, int paramSortType, long paramArgFlag) throws VWException {
        this.m_cempURI = paramCEMPURL;
        this.m_maxNumToReturn = paramMaxNumToReturn;
        if (this.m_maxNumToReturn == 0) {
            this.m_maxNumToReturn = 200;
        }
        this.m_queryType = paramQueryType;
        this.m_startRecord = paramStartRecord;
        this.m_searchPattern = paramSearchPattern;
        this.m_domain = paramDomain;
        this.m_searchType = paramSearchType;
        this.m_sortType = paramSortType;
        this.m_argFlag = paramArgFlag;
        this.lastTouched = Calendar.getInstance();
    }

    protected void setStartRecord(String s) {
        this.m_startRecord = s;
    }

    protected void setLastTouched() {
        this.lastTouched = Calendar.getInstance();
    }

    protected Calendar getLastTouched() {
        return this.lastTouched;
    }

    public Object run() throws VWException {
        boolean explicitRealm;
        String m_method = "run";
        if (this.theQueryIsOver) {
            throw new VWException("filenet.pe.peorb.client.ORBFetchUserList.noMoreData", "The Query Is Over");
        }
        this.numberFetchedThisTime = 0;
        if (this.firstTime) {
            if (logger.isFinest()) {
                logger.finest(m_className, "run", "First Time through: initializing connection, chunksize=" + this.m_maxNumToReturn);
            }
            this.myConnection = Factory.Connection.getConnection((String)this.m_cempURI);
            this.entireNetwork = Factory.EntireNetwork.fetchInstance((Connection)this.myConnection, null);
            this.allRealms = this.entireNetwork.get_AllRealms();
            this.realmIter = this.allRealms.iterator();
        }
        Vector<VWParticipant> consolidatedParticipants = new Vector<VWParticipant>(200, 100);
        VWParticipant[] consolidatedNamesList = null;
        Long[] theIdList = null;
        String theLastRecord = "";
        String realmName = "";
        boolean bl = explicitRealm = this.m_domain != null && this.m_domain.length() > 0;
        while ((this.realmIter != null && this.realmIter.hasNext() || this.currentRealm != null) && this.numberFetchedThisTime < this.m_maxNumToReturn) {
            if (this.currentRealm == null) {
                if (explicitRealm) {
                    boolean foundHim = false;
                    while (this.realmIter.hasNext() && !foundHim) {
                        this.currentRealm = (Realm)this.realmIter.next();
                        realmName = this.currentRealm.get_Name();
                        foundHim = this.m_domain.equals(realmName);
                    }
                    if (foundHim) {
                        this.realmIter = null;
                    } else {
                        this.currentRealm = null;
                        realmName = "";
                    }
                } else {
                    this.currentRealm = (Realm)this.realmIter.next();
                    realmName = this.currentRealm.get_Name();
                }
                this.theUsers = null;
                this.userIter = null;
                this.theGroups = null;
                this.groupIter = null;
                this.doneWithThisRealmsUsers = false;
                this.doneWithThisRealmsGroups = false;
            } else {
                realmName = this.currentRealm.get_Name();
                if (logger.isFinest()) {
                    logger.finest(m_className, "run", "  Continuing processing with current realm: " + realmName);
                }
            }
            if (this.currentRealm == null) continue;
            if (this.m_searchPattern == null) {
                this.m_searchPattern = "";
            }
            PrincipalSearchAttribute searchAttribute = this.m_searchPattern.equals("") ? PrincipalSearchAttribute.NONE : ((this.m_argFlag & 0x10000L) == 65536L ? PrincipalSearchAttribute.DISPLAY_NAME : PrincipalSearchAttribute.SHORT_NAME);
            PrincipalSearchType searchType = PrincipalSearchType.getInstanceFromInt((int)this.m_searchType);
            if (searchType == PrincipalSearchType.NONE) {
                this.m_searchPattern = "";
            }
            PrincipalSearchSortType sortType = PrincipalSearchSortType.getInstanceFromInt((int)this.m_sortType);
            if (logger.isFinest()) {
                logger.finest(m_className, "run", "  Processing Realm: " + realmName + ", queryType=" + this.m_queryType);
                logger.finest(m_className, "run", "   m_argFlag=" + this.m_argFlag + " searchPattern=" + this.m_searchPattern + ", searchType=" + searchType);
                logger.finest(m_className, "run", "   searchAttribute(new)=" + searchAttribute.toString() + ", searchSortType=" + sortType);
            }
            if (this.m_queryType == 1 || this.m_queryType == 3) {
                if (this.theUsers == null && !this.doneWithThisRealmsUsers) {
                    try {
                        this.theUsers = this.currentRealm.findUsers(this.m_searchPattern, searchType, searchAttribute, sortType, Integer.valueOf(50), pf);
                    }
                    catch (Exception e) {
                        this.theUsers = null;
                    }
                }
                if (this.theUsers == null) {
                    this.doneWithThisRealmsUsers = true;
                }
            }
            if (this.m_queryType == 2 || this.m_queryType == 3) {
                if (this.theGroups == null && !this.doneWithThisRealmsGroups) {
                    try {
                        this.theGroups = this.currentRealm.findGroups(this.m_searchPattern, searchType, searchAttribute, sortType, Integer.valueOf(50), pf);
                    }
                    catch (Exception e) {
                        this.theGroups = null;
                    }
                }
                if (this.theGroups == null) {
                    this.doneWithThisRealmsGroups = true;
                }
            }
            int startedWith = this.numberFetchedThisTime;
            if (this.theUsers == null) {
                this.doneWithThisRealmsUsers = true;
            } else {
                if (this.userIter == null) {
                    this.userIter = this.theUsers.iterator();
                }
                while (this.userIter.hasNext() && this.numberFetchedThisTime < this.m_maxNumToReturn) {
                    User user = (User)this.userIter.next();
                    consolidatedParticipants.add(VWClassFactory.createVWParticipant(realmName, user.get_ShortName(), user.get_DistinguishedName(), user.get_DisplayName(), user.get_Id(), 0L, 1, 234L));
                    ++this.numberFetchedThisTime;
                }
                if (!this.userIter.hasNext()) {
                    this.userIter = null;
                    this.theUsers = null;
                    this.doneWithThisRealmsUsers = true;
                }
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "run", "Users found on this call: " + (this.numberFetchedThisTime - startedWith) + " in " + realmName);
            }
            startedWith = this.numberFetchedThisTime;
            if (this.theGroups == null) {
                this.doneWithThisRealmsGroups = true;
            } else {
                if (this.groupIter == null) {
                    this.groupIter = this.theGroups.iterator();
                }
                while (this.groupIter.hasNext() && this.numberFetchedThisTime < this.m_maxNumToReturn) {
                    Group group = (Group)this.groupIter.next();
                    consolidatedParticipants.add(VWClassFactory.createVWParticipant(realmName, group.get_ShortName(), group.get_DistinguishedName(), group.get_DisplayName(), group.get_Id(), 0L, 2, 234L));
                    ++this.numberFetchedThisTime;
                }
                if (!this.groupIter.hasNext()) {
                    this.groupIter = null;
                    this.theGroups = null;
                    this.doneWithThisRealmsGroups = true;
                }
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "run", "Groups found on this call: " + (this.numberFetchedThisTime - startedWith) + " in " + realmName);
            }
            if (!this.doneWithThisRealmsUsers || !this.doneWithThisRealmsGroups) continue;
            this.currentRealm = null;
        }
        if (this.realmIter != null && !this.realmIter.hasNext()) {
            this.realmIter = null;
        }
        int ourCount = consolidatedParticipants.size();
        consolidatedNamesList = new VWParticipant[ourCount];
        Iterator theParticipants = consolidatedParticipants.iterator();
        for (int i = 0; i < ourCount; ++i) {
            consolidatedNamesList[i] = (VWParticipant)theParticipants.next();
        }
        if (ourCount > 0) {
            theLastRecord = consolidatedNamesList[ourCount - 1].toString();
        }
        this.theQueryIsOver = this.currentRealm == null && this.groupIter == null && this.userIter == null;
        this.firstTime = false;
        VWSecurityQueryResults myQueryResults = new VWSecurityQueryResults(consolidatedNamesList, theIdList, theLastRecord, this.theQueryIsOver);
        if (logger.isFinest()) {
            logger.finest(m_className, "run", "Returning " + ourCount + " Participants, and theQueryIsOver=" + this.theQueryIsOver);
        }
        return myQueryResults;
    }

    static {
        pf = new PropertyFilter();
        pf.addIncludeType(1, null, null, FilteredPropertyType.ANY);
        pf.addExcludeProperty("ClassDescriptions");
    }
}

